<?php

namespace App\Http\Controllers\Website;

use Carbon\Carbon;
use App\Models\Blog;
use App\Models\Page;
use App\Models\Plan;
use App\Models\Config;
use App\Models\Setting;
use App\Models\Currency;
use App\Models\IpAddress;
use App\Classes\NonStorage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use Artesaos\SEOTools\Facades\JsonLd;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Facades\SEOTools;
use Artesaos\SEOTools\Facades\OpenGraph;
use Illuminate\Support\Facades\Artisan;

class WebController extends Controller
{
    // Web Index
    public function webIndex()
    {
        // Queries
        $config = Config::get();

        // Check website
        if ($config[46]->config_value == "yes") {
            // Plans
            $page = Page::where('slug', 'home')->where('status', 1)->get();

            // Create storage link
            Artisan::call('storage:link');

            // Check page
            if (!$page->isEmpty()) {
                $plans = Plan::where('status', 1)->where('is_private', '0')->get();
                $currency = Currency::where('iso_code', $config['1']->config_value)->first();
                $setting = Setting::where('status', 1)->first();

                // Get access types
                $access_types = "";
                $acceptedFiles = "";
                $_access_types = json_decode($config[37]->config_value);
                for ($i = 0; $i < count($_access_types); $i++) {
                    if ($_access_types[$i] == '.jpg') {
                        $access_types .= 'JPG, ';
                        $acceptedFiles .= '.jpg,';
                    } else if ($_access_types[$i] == '.jpeg') {
                        $access_types .= 'JPEG, ';
                        $acceptedFiles .= '.jpeg,';
                    } else if ($_access_types[$i] == '.svg') {
                        $access_types .= 'SVG, ';
                        $acceptedFiles .= '.svg,';
                    } else if ($_access_types[$i] == '.webp') {
                        $access_types .= 'WEBP, ';
                        $acceptedFiles .= '.webp,';
                    } else if ($_access_types[$i] == '.gif') {
                        $access_types .= 'GIF, ';
                        $acceptedFiles .= '.gif,';
                    } else if ($_access_types[$i] == '.png') {
                        $access_types .= 'PNG, ';
                        $acceptedFiles .= '.png,';
                    }
                }

                // Check plan for free
                $planPrices = [];
                for ($j = 0; $j < count($plans); $j++) {
                    $planPrices[$j] = $plans[$j]->price;
                }

                // Credit card required
                $requiredCreditCard = false;
                if (in_array("0.00", $planPrices)) {
                    $requiredCreditCard = true;
                }

                // Seo Tools
                SEOTools::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOTools::setDescription($page[0]->description);

                SEOMeta::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOMeta::setDescription($page[0]->description);
                SEOMeta::addMeta('article:section', $page[0]->name . ' - ' . $page[0]->meta_title, 'property');
                SEOMeta::addKeyword([$page[0]->keywords]);

                OpenGraph::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                OpenGraph::setDescription($page[0]->description);
                OpenGraph::setUrl(URL::full());
                OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

                JsonLd::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                JsonLd::setDescription($page[0]->description);
                JsonLd::addImage(asset($setting->site_logo));

                // Return values
                $returnValues = compact('plans', 'config', 'currency', 'access_types', 'acceptedFiles', 'setting', 'requiredCreditCard');

                // Check selected theme
                if ($config[48]->config_value == "513402991882314") {
                    // view
                    return view("website.classic.index", $returnValues);
                } else if ($config[48]->config_value == "330599619570398") {
                    // view
                    return view("website.modern.index", $returnValues);
                }
            } else {
                abort(404);
            }
        } else {
            return redirect('/login');
        }
    }

    // Web Features 
    public function webFeatures()
    {
        // Queries
        $config = Config::get();

        // Check website
        if ($config[46]->config_value == "yes") {
            // Queries
            $page = Page::where('slug', 'home')->where('status', 1)->get();

            // Check page
            if (!$page->isEmpty()) {
                $setting = Setting::where('status', 1)->first();

                // Seo Tools
                SEOTools::setTitle(trans('Features'). ' - ' . $page[0]->meta_title);
                SEOTools::setDescription($page[0]->description);

                SEOMeta::setTitle(trans('Features'). ' - ' . $page[0]->meta_title);
                SEOMeta::setDescription($page[0]->description);
                SEOMeta::addMeta('article:section', trans('Features'), 'property');
                SEOMeta::addKeyword([$page[0]->keywords]);

                OpenGraph::setTitle(trans('Features'). ' - ' . $page[0]->meta_title);
                OpenGraph::setDescription($page[0]->description);
                OpenGraph::setUrl(URL::full());
                OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

                JsonLd::setTitle(trans('Features'). ' - ' . $page[0]->meta_title);
                JsonLd::setDescription($page[0]->description);
                JsonLd::addImage(asset($setting->site_logo));

                // Return values
                $returnValues = compact('config', 'setting');

                // Check selected theme
                if ($config[48]->config_value == "513402991882314") {
                    // view
                    return view("website.classic.pages.features", $returnValues);
                } else if ($config[48]->config_value == "330599619570398") {
                    // view
                    return view("website.modern.pages.features", $returnValues);
                }
            } else {
                abort(404);
            }
        } else {
            return redirect('/login');
        }
    }

    // Web About 
    public function webAbout()
    {
        // Queries
        $config = Config::get();

        // Check website
        if ($config[46]->config_value == "yes") {
            // Queries
            $page = Page::where('slug', 'about')->where('status', 1)->get();

            // Check page
            if (!$page->isEmpty()) {
                $setting = Setting::where('status', 1)->first();

                // Seo Tools
                SEOTools::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOTools::setDescription($page[0]->description);

                SEOMeta::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOMeta::setDescription($page[0]->description);
                SEOMeta::addMeta('article:section', $page[0]->name . ' - ' . $page[0]->meta_title, 'property');
                SEOMeta::addKeyword([$page[0]->keywords]);

                OpenGraph::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                OpenGraph::setDescription($page[0]->description);
                OpenGraph::setUrl(URL::full());
                OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

                JsonLd::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                JsonLd::setDescription($page[0]->description);
                JsonLd::addImage(asset($setting->site_logo));

                // Return values
                $returnValues = compact('config', 'setting');

                // Check selected theme
                if ($config[48]->config_value == "513402991882314") {
                    // view
                    return view("website.classic.pages.about", $returnValues);
                } else if ($config[48]->config_value == "330599619570398") {
                    // view
                    return view("website.modern.pages.about", $returnValues);
                }
            } else {
                abort(404);
            }
        } else {
            return redirect('/login');
        }
    }

    // Web Pricing
    public function webPricing()
    {
        // Queries
        $config = Config::get();

        // Check website
        if ($config[46]->config_value == "yes") {
            // Plans
            $page = Page::where('slug', 'pricing')->where('status', 1)->get();

            // Check page
            if (!$page->isEmpty()) {
                $plans = Plan::where('status', 1)->where('is_private', '0')->get();
                $currency = Currency::where('iso_code', $config['1']->config_value)->first();
                $setting = Setting::where('status', 1)->first();

                // Seo Tools
                SEOTools::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOTools::setDescription($page[0]->description);

                SEOMeta::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOMeta::setDescription($page[0]->description);
                SEOMeta::addMeta('article:section', $page[0]->name . ' - ' . $page[0]->meta_title, 'property');
                SEOMeta::addKeyword([$page[0]->keywords]);

                OpenGraph::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                OpenGraph::setDescription($page[0]->description);
                OpenGraph::setUrl(URL::full());
                OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

                JsonLd::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                JsonLd::setDescription($page[0]->description);
                JsonLd::addImage(asset($setting->site_logo));

                // Return values
                $returnValues = compact('plans', 'config', 'currency', 'setting');

                // Check selected theme
                if ($config[48]->config_value == "513402991882314") {
                    // view
                    return view("website.classic.pages.pricing", $returnValues);
                } else if ($config[48]->config_value == "330599619570398") {
                    // view
                    return view("website.modern.pages.pricing", $returnValues);
                }
            } else {
                abort(404);
            }
        } else {
            return redirect('/login');
        }
    }

    // Web Contact
    public function webContact()
    {
        // Queries
        $config = Config::get();

        // Check website
        if ($config[46]->config_value == "yes") {
            // Queries
            $page = Page::where('slug', 'contact')->where('status', 1)->get();

            // Check page
            if (!$page->isEmpty()) {
                $setting = Setting::where('status', 1)->first();

                // Seo Tools
                SEOTools::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOTools::setDescription($page[0]->description);

                SEOMeta::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOMeta::setDescription($page[0]->description);
                SEOMeta::addMeta('article:section', $page[0]->name . ' - ' . $page[0]->meta_title, 'property');
                SEOMeta::addKeyword([$page[0]->keywords]);

                OpenGraph::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                OpenGraph::setDescription($page[0]->description);
                OpenGraph::setUrl(URL::full());
                OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

                JsonLd::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                JsonLd::setDescription($page[0]->description);
                JsonLd::addImage(asset($setting->site_logo));

                // Return values
                $returnValues = compact('config', 'setting', 'page');

                // Check selected theme
                if ($config[48]->config_value == "513402991882314") {
                    // view
                    return view("website.classic.pages.contact", $returnValues);
                } else if ($config[48]->config_value == "330599619570398") {
                    // view
                    return view("website.modern.pages.contact", $returnValues);
                }
            } else {
                abort(404);
            }
        } else {
            return redirect('/login');
        }
    }

    // Web FAQs
    public function webFAQ()
    {
        // Queries
        $config = Config::get();

        // Check website
        if ($config[46]->config_value == "yes") {
            // Queries
            $page = Page::where('slug', 'faq')->where('status', 1)->get();

            // Check page
            if (!$page->isEmpty()) {
                $setting = Setting::where('status', 1)->first();

                // Seo Tools
                SEOTools::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOTools::setDescription($page[0]->description);

                SEOMeta::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOMeta::setDescription($page[0]->description);
                SEOMeta::addMeta('article:section', $page[0]->name . ' - ' . $page[0]->meta_title, 'property');
                SEOMeta::addKeyword([$page[0]->keywords]);

                OpenGraph::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                OpenGraph::setDescription($page[0]->description);
                OpenGraph::setUrl(URL::full());
                OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

                JsonLd::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                JsonLd::setDescription($page[0]->description);
                JsonLd::addImage(asset($setting->site_logo));

                // Return values
                $returnValues = compact('config', 'setting');

                // Check selected theme
                if ($config[48]->config_value == "513402991882314") {
                    // view
                    return view("website.classic.pages.faq", $returnValues);
                } else if ($config[48]->config_value == "330599619570398") {
                    // view
                    return view("website.modern.pages.faq", $returnValues);
                }
            } else {
                abort(404);
            }
        } else {
            return redirect('/login');
        }
    }

    // Web Privacy
    public function webPrivacy()
    {
        // Queries
        $config = Config::get();

        // Check website
        if ($config[46]->config_value == "yes") {
            // Queries
            $page = Page::where('slug', 'privacy-policy')->where('status', 1)->get();

            // Check page
            if (!$page->isEmpty()) {
                $setting = Setting::where('status', 1)->first();

                // Seo Tools
                SEOTools::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOTools::setDescription($page[0]->description);

                SEOMeta::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOMeta::setDescription($page[0]->description);
                SEOMeta::addMeta('article:section', $page[0]->name . ' - ' . $page[0]->meta_title, 'property');
                SEOMeta::addKeyword([$page[0]->keywords]);

                OpenGraph::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                OpenGraph::setDescription($page[0]->description);
                OpenGraph::setUrl(URL::full());
                OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

                JsonLd::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                JsonLd::setDescription($page[0]->description);
                JsonLd::addImage(asset($setting->site_logo));

                // Return values
                $returnValues = compact('config', 'setting');

                // Check selected theme
                if ($config[48]->config_value == "513402991882314") {
                    // view
                    return view("website.classic.pages.privacy", $returnValues);
                } else if ($config[48]->config_value == "330599619570398") {
                    // view
                    return view("website.modern.pages.privacy", $returnValues);
                }
            } else {
                abort(404);
            }
        } else {
            return redirect('/login');
        }
    }

    // Web Refund
    public function webRefund()
    {
        // Queries
        $config = Config::get();

        // Check website
        if ($config[46]->config_value == "yes") {
            // Queries
            $page = Page::where('slug', 'refund-policy')->where('status', 1)->get();

            // Check page
            if (!$page->isEmpty()) {
                $setting = Setting::where('status', 1)->first();

                // Seo Tools
                SEOTools::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOTools::setDescription($page[0]->description);

                SEOMeta::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOMeta::setDescription($page[0]->description);
                SEOMeta::addMeta('article:section', $page[0]->name . ' - ' . $page[0]->meta_title, 'property');
                SEOMeta::addKeyword([$page[0]->keywords]);

                OpenGraph::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                OpenGraph::setDescription($page[0]->description);
                OpenGraph::setUrl(URL::full());
                OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

                JsonLd::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                JsonLd::setDescription($page[0]->description);
                JsonLd::addImage(asset($setting->site_logo));

                // Return values
                $returnValues = compact('config', 'setting');

                // Check selected theme
                if ($config[48]->config_value == "513402991882314") {
                    // view
                    return view("website.classic.pages.refund", $returnValues);
                } else if ($config[48]->config_value == "330599619570398") {
                    // view
                    return view("website.modern.pages.refund", $returnValues);
                }
            } else {
                abort(404);
            }
        } else {
            return redirect('/login');
        }
    }

    // Web Terms
    public function webTerms()
    {
        // Queries
        $config = Config::get();

        // Check website
        if ($config[46]->config_value == "yes") {
            // Queries
            $page = Page::where('slug', 'terms-and-conditions')->where('status', 1)->get();

            // Check page
            if (!$page->isEmpty()) {
                $setting = Setting::where('status', 1)->first();

                // Seo Tools
                SEOTools::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOTools::setDescription($page[0]->description);

                SEOMeta::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                SEOMeta::setDescription($page[0]->description);
                SEOMeta::addMeta('article:section', $page[0]->name . ' - ' . $page[0]->meta_title, 'property');
                SEOMeta::addKeyword([$page[0]->keywords]);

                OpenGraph::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                OpenGraph::setDescription($page[0]->description);
                OpenGraph::setUrl(URL::full());
                OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

                JsonLd::setTitle($page[0]->name . ' - ' . $page[0]->meta_title);
                JsonLd::setDescription($page[0]->description);
                JsonLd::addImage(asset($setting->site_logo));

                // Return values
                $returnValues = compact('config', 'setting');

                // Check selected theme
                if ($config[48]->config_value == "513402991882314") {
                    // view
                    return view("website.classic.pages.terms", $returnValues);
                } else if ($config[48]->config_value == "330599619570398") {
                    // view
                    return view("website.modern.pages.terms", $returnValues);
                }
            } else {
                abort(404);
            }
        } else {
            return redirect('/login');
        }
    }

    // Custom pages
    public function customPage($id)
    {
        // Queries
        $config = Config::get();

        // Check website
        if ($config[46]->config_value == "yes") {
            // Get page details
            $page = Page::where('slug', $id)->where('status', 1)->first();
            $setting = Setting::where('status', 1)->first();

            if (!empty($page)) {

                // Seo Tools
                SEOTools::setTitle($page->name);
                SEOTools::setDescription($page->description);

                SEOMeta::setTitle($page->name);
                SEOMeta::setDescription($page->description);
                SEOMeta::addMeta('article:section', $page->name, 'property');
                SEOMeta::addKeyword([$page->keywords]);

                OpenGraph::setTitle($page->name);
                OpenGraph::setDescription($page->description);
                OpenGraph::setUrl(URL::full());
                OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

                JsonLd::setTitle($page->name);
                JsonLd::setDescription($page->description);
                JsonLd::addImage(asset($setting->site_logo));

                // Return values
                $returnValues = compact('page', 'config', 'setting');

                // Check selected theme
                if ($config[48]->config_value == "513402991882314") {
                    // view
                    return view("website.classic.pages.custom-page", $returnValues);
                } else if ($config[48]->config_value == "330599619570398") {
                    // view
                    return view("website.modern.pages.custom-page", $returnValues);
                }
            } else {
                return abort(404);
            }
        } else {
            return redirect('/login');
        }
    }

    // Image optimize from website without file save
    public function optimizeImage(Request $request)
    {
        // Get optimize details
        $config = Config::get();
        $ipAddressCount = IpAddress::where('ip_address', \Request::getClientIp(true))->whereDate('created_at', Carbon::today())->count();

        // Check IP Address count
        if ($ipAddressCount < (int)$config[40]->config_value) {
            // Check s3 available
            if ($config[34]->config_value == 1) {
                $nonStorage = new NonStorage;
                $nonStorage->nonStorageFunction($request);

                // Saved Ip Address
                $ipAddress = new IpAddress();
                $ipAddress->ip_address = \Request::getClientIp(true);
                $ipAddress->save();

                return response()->json([
                    'status' => true, 'file_name' => $nonStorage->fileName, 'size' => $nonStorage->originalSizes, 'optimizeSize' => $nonStorage->optimizeSizes,
                    'savedYou' => $nonStorage->savedYou, 'url' => $nonStorage->optimizeUrl
                ]);
            } else {
                return response()->json(['status' => false]);
            }
        } else {
            return response()->json(['status' => false, 'message' => trans('Maximum limit reached')]);
        }
    }

    // Download image
    public function downloadImge(Request $request)
    {
        if (file_exists(public_path($request->query('id'))) == true) {
            return response()->download(public_path($request->query('id')))->deleteFileAfterSend(true);
        } else {
            abort(404);
        }
    }

    // Blogs
    public function blogs()
    {
        // Queries
        $blogs = Blog::where('status', 1)->orderBy('created_at', 'desc')->paginate(6);
        $setting = Setting::where('status', 1)->first();
        $config = Config::get();

        // Get page details
        $page = Page::where('slug', 'home')->where('status', 1)->get();

        // Seo Tools
        SEOTools::setTitle('Blogs'. ' - ' . $page[0]->meta_title);
        SEOTools::setDescription('Blogs' . ' - ' . $page[0]->description);

        SEOMeta::setTitle('Blogs'. ' - ' . $page[0]->meta_title);
        SEOMeta::setDescription('Blogs' . ' - ' . $page[0]->description);
        SEOMeta::addMeta('article:section', 'Blogs', 'property');
        SEOMeta::addKeyword([$page[0]->keywords]);

        OpenGraph::setTitle('Blogs'. ' - ' . $page[0]->meta_title);
        OpenGraph::setDescription('Blogs' . ' - ' . $page[0]->description);
        OpenGraph::setUrl(URL::full());
        OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

        JsonLd::setTitle('Blogs'. ' - ' . $page[0]->meta_title);
        JsonLd::setDescription('Blogs' . ' - ' . $page[0]->description);
        JsonLd::addImage(asset($setting->site_logo));

        // Return values
        $returnValues = compact('blogs', 'config', 'setting');

        // Check selected theme
        if ($config[48]->config_value == "513402991882314") {
            // view
            return view("website.classic.pages.blogs.index", $returnValues);
        } else if ($config[48]->config_value == "330599619570398") {
            // view
            return view("website.modern.pages.blogs.index", $returnValues);
        }
    }

    // View blog post
    public function viewBlog($slug)
    {
        // Queries
        $blogDetails = Blog::where('slug', $slug)->where('status', 1)->first();
        $setting = Setting::where('status', 1)->first();
        $config = Config::get();

        if ($blogDetails) {
            // Get page details
            $page = Page::where('slug', 'home')->where('status', 1)->get();

            // Recent blogs (except current viewed blog)
            $recentBlogs = Blog::where('slug', '!=', $slug)->where('status', 1)->limit(2)->orderBy('created_at', 'desc')->get();

            // Seo Tools
            SEOTools::setTitle($blogDetails->title);
            SEOTools::setDescription($blogDetails->description);
            SEOTools::addImages(asset($blogDetails->cover_image));

            SEOMeta::setTitle($blogDetails->title);
            SEOMeta::setDescription($blogDetails->description);
            SEOMeta::addMeta('article:section', $blogDetails->title, 'property');
            SEOMeta::addKeyword([$blogDetails->keywords]);

            OpenGraph::setTitle($blogDetails->title);
            OpenGraph::setDescription($blogDetails->description);
            OpenGraph::addProperty('type', 'article');
            OpenGraph::setUrl(url($blogDetails->slug));

            JsonLd::setType('Article');
            JsonLd::setTitle($blogDetails->title);
            JsonLd::setDescription($blogDetails->description);

            // Return values
            $returnValues = compact('blogDetails', 'recentBlogs', 'config', 'setting');

            // Check selected theme
            if ($config[48]->config_value == "513402991882314") {
                // view
                return view("website.classic.pages.blogs.view", $returnValues);
            } else if ($config[48]->config_value == "330599619570398") {
                // view
                return view("website.modern.pages.blogs.view", $returnValues);
            }
        } else {
            abort(404);
        }
    }
}
