<?php

namespace App\Http\Controllers\User;

use App\Models\Plan;
use App\Models\User;
use App\Models\Optimer;
use App\Models\Setting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class TrashController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    // All User Trash Optimer Images
    public function indexTrash()
    {
        // Get plan details
        $active_plan = Plan::where('id', Auth::user()->plan_id)->first();
        // Get user details
        $plan = User::where('id', Auth::user()->id)->first();

        if ($active_plan != null) {
            // Get User Trash Optimer Images
            $trashes = Optimer::where('uploaded_by', Auth::user()->id)->where('status', 0)->orderBy('id', 'desc')->paginate(12);
            $settings = Setting::where('status', 1)->first();

            // View page
            return view('user.pages.optimer.trash.index', compact('trashes', 'settings'));
        } else {
            // Page redirect
            return redirect()->route('user.plans');
        }
    }

    // Restore Optimer
    public function restoreOptimer(Request $request)
    {
        // Get user created optimers counts
        $optimers_counts = Optimer::where('uploaded_by', Auth::user()->id)->count();

        // Get user created optimers overall size
        $optimers_size = Optimer::where('uploaded_by', Auth::user()->id)->sum('actual_image_size');

        // Get plan details
        $plan = User::where('id', Auth::user()->id)->where('status', 1)->first();
        $plan_details = json_decode($plan->plan_details);

        // Check no of optimers
        if ($plan_details->maximum == 9999) {
            $maximum = 9999999999;
        } else {
            $maximum = $plan_details->maximum;
        }

        // Check storage available
        if ($optimers_counts < $maximum && $optimers_size < $plan_details->storage) {
            // Update status
            Optimer::where('id', $request->query('id'))->where('uploaded_by', Auth::user()->id)->update(['status' => 1]);
            return redirect()->route('user.all.trash.optimer')->with('success', trans('Image Restored Successfully!'));
        } else {
            return redirect()->route('user.all.trash.optimer')->with('failed', trans('Maximum optimer creation limit / storage is exceeded, Please upgrade your plan.'));
        }
    }

    // Permanent Delete Optimer
    public function permanentDeleteOptimer(Request $request)
    {
        // Optimer image details
        $imageDetails = Optimer::where('id', $request->query('id'))->where('uploaded_by', Auth::user()->id)->first();

        if ($imageDetails->disk == 'local') {
            try {
                // Delete local image (original image)
                $actual_image = str_replace('/storage/files/' . Auth::user()->id . '/', '', $imageDetails->actual_image);
                unlink(public_path('storage/files/' . Auth::user()->id . '/' . $actual_image));

                // Delete local image (optimized image)
                $optimized_image = str_replace('/storage/files/' . Auth::user()->id . '/optimize/', '', $imageDetails->optimized_image);
                unlink(public_path('storage/files/' . Auth::user()->id . '/optimize/' . $optimized_image));
            } catch (\Throwable $th) {
                //throw $th;
            }
        } else {
            try {
                // Delete s3 image
                Storage::disk('s3')->delete(str_replace(Storage::disk('s3')->url('.'), '', $imageDetails->actual_image));
                Storage::disk('s3')->delete(str_replace(Storage::disk('s3')->url('.'), '', $imageDetails->optimized_image));
            } catch (\Throwable $th) {
                //throw $th;
            }

            // Delete wasabi image
            Storage::disk('wasabi')->delete(str_replace(Storage::disk('wasabi')->url('.'), '', $imageDetails->actual_image));
            Storage::disk('wasabi')->delete(str_replace(Storage::disk('wasabi')->url('.'), '', $imageDetails->optimized_image));
        }

        // Update status
        Optimer::where('id', $request->query('id'))->where('uploaded_by', Auth::user()->id)->update(['status' => -1]);
        return redirect()->route('user.all.trash.optimer')->with('success', trans('Image Permanent Deleted Successfully!'));
    }

    // Permanent delete all trash image
    public function emptyTrash()
    {
        // Trash images
        $trashImages = Optimer::where('uploaded_by', Auth::user()->id)->where('status', 0)->get();

        // Overall trashs
        for ($i = 0; $i < count($trashImages); $i++) {
            if ($trashImages[$i]->disk == 'local') {
                try {
                    // Delete local image (original image)
                    $actual_image = str_replace('/storage/files/' . Auth::user()->id . '/', '', $trashImages[$i]->actual_image);
                    unlink(public_path('storage/files/' . Auth::user()->id . '/' . $actual_image));

                    // Delete local image (optimized image)
                    $optimized_image = str_replace('/storage/files/' . Auth::user()->id . '/optimize/', '', $trashImages[$i]->optimized_image);
                    unlink(public_path('storage/files/' . Auth::user()->id . '/optimize/' . $optimized_image));
                } catch (\Throwable $th) {
                    //throw $th;
                }
            } else {
                try {
                    // Delete s3 image
                    Storage::disk('s3')->delete(str_replace(Storage::disk('s3')->url('.'), '', $trashImages[$i]->actual_image));
                    Storage::disk('s3')->delete(str_replace(Storage::disk('s3')->url('.'), '', $trashImages[$i]->optimized_image));
                } catch (\Throwable $th) {
                    //throw $th;
                }

                // Delete wasabi image
                Storage::disk('wasabi')->delete(str_replace(Storage::disk('wasabi')->url('.'), '', $trashImages[$i]->actual_image));
                Storage::disk('wasabi')->delete(str_replace(Storage::disk('wasabi')->url('.'), '', $trashImages[$i]->optimized_image));
            }
        }

        // Update status
        Optimer::where('uploaded_by', Auth::user()->id)->where('status', 0)->update(['status' => -1]);
        return redirect()->route('user.all.trash.optimer')->with('success', trans('Trash Empty Successfully!'));
    }
}
