<?php

namespace App\Http\Controllers\User;

use App\Models\Plan;
use App\Models\User;
use App\Models\Config;
use App\Models\Setting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class ForDeveloper extends Controller
{
    public function index()
    {
        // Check active plans
        $active_plan = Plan::where('id', Auth::user()->plan_id)->first();

        // Check user plan
        $plan = User::where('id', Auth::user()->id)->first();

        // Check plan
        if ($active_plan != null) {
            // Queries
            $apis = User::where('id', auth()->user()->id)->where('status', 1)->first();
            $settings = Setting::where('status', 1)->first();
            $config = Config::get();

            return view('user.pages.for-developers.index', compact('apis', 'settings', 'config'));
        } else {
            // Page redirect in plan is not activated
            return redirect()->route('user.plans');
        }
    }

    // Generate Key
    public function generateKey(Request $request)
    {
        // Generate Key
        $apiKey = Hash::make('');

        // Update user key
        User::where('id', auth()->user()->id)->update([
            'api_key' => $apiKey
        ]);

        return redirect()->route('user.for.developers')->with('success', trans('New Key Generated Successfully!'));
    }
}
