<?php

namespace App\Http\Controllers\Admin;

use DateTimeZone;
use App\Models\Config;
use App\Models\Setting;
use App\Models\Currency;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class WasabiSettingController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    // General Settings
    public function index()
    {
        // Queries
        $timezonelist = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
        $currencies = Currency::get();
        $settings = Setting::first();
        $config = Config::get();

        return view('admin.pages.settings.wasabi', compact('settings', 'timezonelist', 'currencies', 'config'));
    }


    // Update Wasabi S3 Setting
    public function changeWasabiS3Settings(Request $request)
    {
        // Set new values using putenv (Wasabi)
        $this->updateEnvFile('WAS_ENABLE', $request->wasabi_enable);
        $this->updateEnvFile('WAS_ACCESS_KEY_ID', $request->wasabi_access_key);
        $this->updateEnvFile('WAS_SECRET_ACCESS_KEY', $request->wasabi_secret_key);
        $this->updateEnvFile('WAS_DEFAULT_REGION', $request->wasabi_default_region);
        $this->updateEnvFile('WAS_BUCKET', $request->wasabi_bucket);
        $this->updateEnvFile('WAS_ENDPOINT', $request->wasabi_end_point);

        // Page redirect
        return redirect()->route('admin.wasabi.settings')->with('success', trans('Configurations updated successfully!'));
    }


    // Update change values in .env file
    public function updateEnvFile($key, $value)
    {
        $envPath = base_path('.env');

        // Check if the .env file exists
        if (file_exists($envPath)) {

            // Read the .env file
            $contentArray = file($envPath);

            // Loop through each line to find the key and update its value
            foreach ($contentArray as &$line) {

                // Split the line by '=' to get key and value
                $parts = explode('=', $line, 2);

                // Check if the key matches and update its value
                if (isset($parts[0]) && $parts[0] === $key) {
                    $line = $key . '=' . $value . PHP_EOL;
                }
            }

            // Implode the array back to a string and write it to the .env file
            $newContent = implode('', $contentArray);
            file_put_contents($envPath, $newContent);

            // Reload the environment variables
            putenv($key . '=' . $value);
            $_ENV[$key] = $value;
            $_SERVER[$key] = $value;
        }
    }
}
