<?php

namespace App\Http\Controllers\Admin;

use DateTimeZone;
use App\Models\Config;
use App\Models\Setting;
use App\Models\Currency;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Artisan;
use Spatie\ResponseCache\Facades\ResponseCache;

class SettingController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    // Settings
    public function index()
    {
        // Queries
        $timezonelist = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
        $currencies = Currency::get();
        $settings = Setting::first();
        $config = Config::get();

        // Get email configuration details
        $email_configuration = [
            'driver' => env('MAIL_MAILER', 'smtp'),
            'host' => env('MAIL_HOST', 'smtp.mailgun.org'),
            'port' => env('MAIL_PORT', 587),
            'username' => env('MAIL_USERNAME'),
            'password' => env('MAIL_PASSWORD'),
            'encryption' => env('MAIL_ENCRYPTION', 'tls'),
            'address' => env('MAIL_FROM_ADDRESS'),
            'name' => env('MAIL_FROM_NAME', $settings->site_name),
        ];

        // Get google configuration details
        $google_configuration = [
            'GOOGLE_ENABLE' => env('GOOGLE_ENABLE', ''),
            'GOOGLE_CLIENT_ID' => env('GOOGLE_CLIENT_ID', ''),
            'GOOGLE_CLIENT_SECRET' => env('GOOGLE_CLIENT_SECRET', ''),
            'GOOGLE_REDIRECT' => env('GOOGLE_REDIRECT', '')
        ];

        // Get image limit
        $image_limit = [
            'SIZE_LIMIT' => env('SIZE_LIMIT', '')
        ];

        // Get Recaptcha configuration details
        $recaptcha_configuration = [
            'RECAPTCHA_ENABLE' => env('RECAPTCHA_ENABLE', ''),
            'RECAPTCHA_SITE_KEY' => env('RECAPTCHA_SITE_KEY', ''),
            'RECAPTCHA_SECRET_KEY' => env('RECAPTCHA_SECRET_KEY', '')
        ];

        $settings['email_configuration'] = $email_configuration;
        $settings['google_configuration'] = $google_configuration;
        $settings['recaptcha_configuration'] = $recaptcha_configuration;
        $settings['image_limit'] = $image_limit;

        return view('admin.pages.settings.index', compact('settings', 'timezonelist', 'currencies', 'config'));
    }

    // Tax settings
    public function taxSetting()
    {
        // Queries
        $config = Config::get();
        $settings = Setting::first();

        // Page view
        return view('admin.pages.tax.index', compact('config', 'settings'));
    }

    // Update tax setting
    public function updateTaxSetting(Request $request)
    {
        // Update
        Config::where('config_key', 'invoice_prefix')->update([
            'config_value' => $request->invoice_prefix,
        ]);

        Config::where('config_key', 'invoice_name')->update([
            'config_value' => $request->invoice_name,
        ]);

        Config::where('config_key', 'invoice_email')->update([
            'config_value' => $request->invoice_email,
        ]);

        Config::where('config_key', 'invoice_phone')->update([
            'config_value' => $request->invoice_phone,
        ]);

        Config::where('config_key', 'invoice_address')->update([
            'config_value' => $request->invoice_address,
        ]);

        Config::where('config_key', 'invoice_city')->update([
            'config_value' => $request->invoice_city,
        ]);

        Config::where('config_key', 'invoice_state')->update([
            'config_value' => $request->invoice_state,
        ]);

        Config::where('config_key', 'invoice_zipcode')->update([
            'config_value' => $request->invoice_zipcode,
        ]);

        Config::where('config_key', 'invoice_country')->update([
            'config_value' => $request->invoice_country,
        ]);

        Config::where('config_key', 'tax_name')->update([
            'config_value' => $request->tax_name,
        ]);

        Config::where('config_key', 'tax_number')->update([
            'config_value' => $request->tax_number,
        ]);

        Config::where('config_key', 'tax_value')->update([
            'config_value' => $request->tax_value,
        ]);

        Config::where('config_key', 'invoice_footer')->update([
            'config_value' => $request->invoice_footer,
        ]);

        // Page redirect
        return redirect()->route('admin.tax.setting')->with('success', trans('Invoice Setting Updated Successfully!'));
    }

    // Update email setting
    public function updateEmailSetting(Request $request)
    {
        // Update
        Config::where('config_key', 'email_heading')->update([
            'config_value' => $request->email_heading,
        ]);

        Config::where('config_key', 'email_footer')->update([
            'config_value' => $request->email_footer,
        ]);

        // Page redirect
        return redirect()->route('admin.tax.setting')->with('success', trans('Email Setting Updated Successfully!'));
    }

    // Clear cache
    public function clearCache()
    {
        try {
            // Clear application cache
            Cache::flush();

            // Clear caches using Artisan
            Artisan::call('cache:clear');  // Clear application cache
            Artisan::call('route:clear');  // Clear route cache
            Artisan::call('config:clear'); // Clear configuration cache
            Artisan::call('view:clear');   // Clear compiled view files

            // Delete all files in bootstrap/cache except .gitignore
            $cachePath  = base_path('bootstrap/cache');
            $cacheFiles = File::files($cachePath);
            foreach ($cacheFiles as $file) { 
                if ($file->getFilename() !== '.gitignore') {
                    File::delete($file);
                }
            }

            // Delete all files in storage/framework/cache except .gitignore
            $cachePath  = base_path('storage/framework/cache');
            $cacheFiles = File::files($cachePath);
            foreach ($cacheFiles as $file) {
                if ($file->getFilename() !== '.gitignore') {
                    File::delete($file);
                }
            }

            // Delete all files in storage/framework/views except .gitignore
            $cachePath  = base_path('storage/framework/views');
            $cacheFiles = File::files($cachePath);
            foreach ($cacheFiles as $file) {
                if ($file->getFilename() !== '.gitignore') {
                    File::delete($file);
                }
            }

            return redirect()->route('admin.dashboard')->with('success', trans('Application Cache Cleared Successfully!'));
        } catch (\Exception $e) {
            return redirect()->route('admin.dashboard')->with('failed', trans('Failed to Clear Cache. Due to the following error: ') . ' ' . $e->getMessage());
        }
    }

    // Test email
    public function testEmail()
    {
        $message = [
            'msg' => 'Test mail'
        ];
        $mail = false;
        try {
            Mail::to(ENV('MAIL_FROM_ADDRESS'))->send(new \App\Mail\TestMail($message));
            $mail = true;
        } catch (\Exception $e) {
            // Page redirect
            return redirect()->route('admin.general.settings')->with('failed', trans('Email configuration wrong.'));
        }
        // Check email
        if ($mail == true) {
            // Page redirect
            return redirect()->route('admin.general.settings')->with('success', trans('Test mail send successfully.'));
        }
    }
}
