<?php

namespace App\Http\Controllers\Admin;

use App\Models\Plan;
use App\Models\Config;
use App\Models\Setting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class PlanController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    // All Plans
    public function index()
    {
        // Queries
        $plans = Plan::get();
        $currencies = Setting::where('status', 1)->get();
        $settings = Setting::where('status', 1)->first();
        $config = Config::get();

        return view('admin.pages.plans.index', compact('plans', 'currencies', 'settings', 'config'));
    }

    // Add Plan
    public function addPlan()
    {
        // Queries
        $config = Config::get();
        $settings = Setting::where('status', 1)->first();

        return view('admin.pages.plans.add', compact('settings', 'config'));
    }

    // Save Plan
    public function savePlan(Request $request)
    {
        // Validation
        $validator = $request->validate([
            'name' => 'required',
            'description' => 'required',
            'price' => 'required',
            'validity' => 'required',
            'formats' => 'required',
            'maximum' => 'required',
            'size' => 'required',
            'storage' => 'required'
        ]);

        // Cloud Storage (S3)
        if ($request->s3 == null) {
            $s3 = 0;
        } else {
            $s3 = 1;
        }

        // PNG
        if ($request->png == null) {
            $png = 0;
        } else {
            $png = 1;
        }

        // JPG
        if ($request->jpg == null) {
            $jpg = 0;
        } else {
            $jpg = 1;
        }

        // SVG
        if ($request->svg == null) {
            $svg = 0;
        } else {
            $svg = 1;
        }

        // WEBP
        if ($request->webp == null) {
            $webp = 0;
        } else {
            $webp = 1;
        }

        // GIF
        if ($request->gif == null) {
            $gif = 0;
        } else {
            $gif = 1;
        }

        // Daily Usage Statistics
        if ($request->statistics == null) {
            $statistics = 0;
        } else {
            $statistics = 1;
        }

        // Media Library
        if ($request->media_library == null) {
            $media_library = 0;
        } else {
            $media_library = 1;
        }

        // Conversation APIs
        if ($request->api == null) {
            $api = 0;
        } else {
            $api = 1;
        }

        // Conversation APIs
        if ($request->limit == null) {
            $limit = 0;
        } else {
            $limit = $request->limit;
        }

        // Additional Tools
        if ($request->additional_tools == null) {
            $additional_tools = 0;
        } else {
            $additional_tools = 1;
        }

        // Support
        if ($request->support == null) {
            $support = 0;
        } else {
            $support = 1;
        }

        // Recommended
        if ($request->recommended == null) {
            $recommended = 0;
        } else {
            $recommended = 1;
        }

        // Is Private?
        if ($request->is_private == null) {
            $is_private = 0;
        } else {
            $is_private = 1;
        }

        // Save plan
        $plan = new Plan;
        $plan->is_private = $is_private;
        $plan->name = $request->name;
        $plan->description = $request->description;
        $plan->recommended = $recommended;
        $plan->price = $request->price;
        $plan->validity = $request->validity;
        $plan->formats = $request->formats;
        $plan->maximum = $request->maximum;
        $plan->size = $request->size;
        $plan->storage = $request->storage;
        $plan->s3 = $s3;
        $plan->png = $png;
        $plan->jpg = $jpg;
        $plan->svg = $svg;
        $plan->webp = $webp;
        $plan->gif = $gif;
        $plan->statistics = $statistics;
        $plan->media_library = $media_library;
        $plan->api = $api;
        $plan->limit = $limit;
        $plan->additional_tools = $additional_tools;
        $plan->support = $support;
        $plan->save();

        return redirect()->route('admin.add.plan')->with('success', trans('New Plan Created Successfully!'));
    }

    // Edit Plan
    public function editPlan(Request $request, $id)
    {
        // Queries
        $id = $request->id;
        $plan_details = Plan::where('id', $id)->first();
        $settings = Setting::where('status', 1)->first();
        $config = Config::get();

        // Plan Checking
        if ($plan_details == null) {
            return view('errors.404');
        } else {
            return view('admin.pages.plans.edit', compact('plan_details', 'settings', 'config'));
        }
    }

    // Update Plan
    public function updatePlan(Request $request)
    {
        // Validation
        $validator = $request->validate([
            'plan_id' => 'required',
            'name' => 'required',
            'description' => 'required',
            'price' => 'required',
            'validity' => 'required',
            'formats' => 'required',
            'maximum' => 'required',
            'size' => 'required',
            'storage' => 'required'
        ]);

        // Cloud Storage (S3)
        if ($request->s3 == null) {
            $s3 = 0;
        } else {
            $s3 = 1;
        }

        // PNG
        if ($request->png == null) {
            $png = 0;
        } else {
            $png = 1;
        }

        // JPG
        if ($request->jpg == null) {
            $jpg = 0;
        } else {
            $jpg = 1;
        }

        // SVG
        if ($request->svg == null) {
            $svg = 0;
        } else {
            $svg = 1;
        }

        // WEBP
        if ($request->webp == null) {
            $webp = 0;
        } else {
            $webp = 1;
        }

        // GIF
        if ($request->gif == null) {
            $gif = 0;
        } else {
            $gif = 1;
        }

        // Daily Usage Statistics
        if ($request->statistics == null) {
            $statistics = 0;
        } else {
            $statistics = 1;
        }

        // Media Library
        if ($request->media_library == null) {
            $media_library = 0;
        } else {
            $media_library = 1;
        }

        // Conversation APIs
        if ($request->api == null) {
            $api = 0;
        } else {
            $api = 1;
        }

        // Conversation APIs
        if ($request->limit == null) {
            $limit = 0;
        } else {
            $limit = $request->limit;
        }

        // Additional Tools
        if ($request->additional_tools == null) {
            $additional_tools = 0;
        } else {
            $additional_tools = 1;
        }

        // Support
        if ($request->support == null) {
            $support = 0;
        } else {
            $support = 1;
        }

        // Recommended
        if ($request->recommended == null) {
            $recommended = 0;
        } else {
            $recommended = 1;
        }

        // Is Private?
        if ($request->is_private == null) {
            $is_private = 0;
        } else {
            $is_private = 1;
        }

        // Update plan
        Plan::where('id', $request->plan_id)->update([
            'is_private' => $is_private, 'name' => $request->name, 'description' => $request->description, 'recommended' => $recommended,
            'price' => $request->price, 'validity' => $request->validity, 'formats' => $request->formats,
            'maximum' => $request->maximum, 'size' => $request->size, 'storage' => $request->storage, 's3' => $s3,
            'png' => $png, 'jpg' => $jpg, 'svg' => $svg, 'webp' => $webp, 'gif' => $gif, 'statistics' => $statistics, 'media_library' => $media_library,
            'api' => $api, 'limit' => $limit, 'additional_tools' => $additional_tools, 'support' => $support
        ]);

        return redirect()->route('admin.edit.plan', $request->plan_id)->with('success', trans('Plan Details Updated Successfully!'));
    }

    // Delete Plan
    public function deletePlan(Request $request)
    {
        // Get plan details
        $plan_details = Plan::where('id', $request->query('id'))->first();

        // Check status
        if ($plan_details->status == 0) {
            $status = 1;
        } else {
            $status = 0;
        }

        // Update status
        Plan::where('id', $request->query('id'))->update(['status' => $status]);
        return redirect()->route('admin.index.plans')->with('success', trans('Plan Status Updated Successfully!'));
    }
}
