<?php

namespace App\Http\Controllers\Admin;

use DateTimeZone;
use App\Models\Config;
use App\Models\Setting;
use App\Models\Currency;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class PaymentSettingController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    // General Settings
    public function index()
    {
        // Queries
        $timezonelist = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
        $currencies = Currency::get();
        $settings = Setting::first();
        $config = Config::get();

        // Get image limit
        $image_limit = [
            'SIZE_LIMIT' => env('SIZE_LIMIT', '')
        ];

        $settings['image_limit'] = $image_limit;

        return view('admin.pages.settings.payment', compact('settings', 'timezonelist', 'currencies', 'config'));
    }

    // Update Payments Setting
    public function changePaymentsSettings(Request $request)
    {
        // Paypal
        Config::where('config_key', 'paypal_mode')->update([
            'config_value' => $request->paypal_mode,
        ]);

        Config::where('config_key', 'paypal_client_id')->update([
            'config_value' => $request->paypal_client_key,
        ]);

        Config::where('config_key', 'paypal_secret')->update([
            'config_value' => $request->paypal_secret,
        ]);

        // Razorpay
        Config::where('config_key', 'razorpay_key')->update([
            'config_value' => $request->razorpay_client_key,
        ]);

        Config::where('config_key', 'razorpay_secret')->update([
            'config_value' => $request->razorpay_secret,
        ]);

        // PhonePe
        Config::where('config_key', 'merchantId')->update([
            'config_value' => $request->merchantId,
        ]);

        Config::where('config_key', 'saltKey')->update([
            'config_value' => $request->saltKey,
        ]);

        // Stripe
        Config::where('config_key', 'stripe_publishable_key')->update([
            'config_value' => $request->stripe_publishable_key,
        ]);

        Config::where('config_key', 'stripe_secret')->update([
            'config_value' => $request->stripe_secret,
        ]);

        // Paystack
        Config::where('config_key', 'paystack_public_key')->update([
            'config_value' => $request->paystack_public_key,
        ]);

        Config::where('config_key', 'paystack_secret_key')->update([
            'config_value' => $request->paystack_secret,
        ]);

        Config::where('config_key', 'merchant_email')->update([
            'config_value' => $request->merchant_email,
        ]);

        // Mollie
        Config::where('config_key', 'mollie_key')->update([
            'config_value' => $request->mollie_key,
        ]);

        // Bank transfer
        Config::where('config_key', 'bank_transfer')->update([
            'config_value' => $request->bank_transfer,
        ]);

        // Page redirect
        return redirect()->route('admin.payments.settings')->with('success', trans('Payment Settings Updated Successfully!'));
    }
}
