<?php

namespace App\Http\Controllers\Admin;

use DateTimeZone;
use App\Models\Config;
use App\Models\Setting;
use App\Models\Currency;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class OptimerSettingController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    // General Settings
    public function index()
    {
        // Queries
        $timezonelist = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
        $currencies = Currency::get();
        $settings = Setting::first();
        $config = Config::get();

        return view('admin.pages.settings.optimer', compact('settings', 'timezonelist', 'currencies', 'config'));
    }

    // Update email setting
    public function changeOptimerSettings(Request $request)
    {
        // Update
        Config::where('config_key', 'optimer_enable')->update([
            'config_value' => $request->optimer_enable,
        ]);

        Config::where('config_key', 'limit_upto')->update([
            'config_value' => $request->limit_upto,
        ]);

        Config::where('config_key', 'size_upto')->update([
            'config_value' => $request->size_upto,
        ]);

        Config::where('config_key', 'support_types')->update([
            'config_value' => $request->support_types,
        ]);

        Config::where('config_key', 'jpg_quality')->update([
            'config_value' => $request->jpg_quality,
        ]);

        Config::where('config_key', 'svg_quality')->update([
            'config_value' => $request->svg_quality,
        ]);

        Config::where('config_key', 'ip_address')->update([
            'config_value' => $request->ip_address,
        ]);

        // Page redirect
        return redirect()->route('admin.optimer.settings')->with('success', trans('Optimer Settings Updated Successfully!'));
    }
}
