<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use App\Models\Config;
use App\Models\Setting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class ForDeveloper extends Controller
{
    public function index()
    {
        // Queries
        $apis = User::where('id', auth()->user()->id)->where('status', 1)->first();
        $settings = Setting::where('status', 1)->first();
        $config = Config::get();

        return view('admin.pages.for-developers.index', compact('apis', 'settings', 'config'));
    }

    // Generate Key
    public function generateKey(Request $request)
    {
        // Generate Key
        $apiKey = Hash::make('');

        // Update user key
        User::where('id', auth()->user()->id)->update([
            'api_key' => $apiKey
        ]);

        return redirect()->route('admin.for.developers')->with('success', trans('New Key Generated Successfully!'));
    }
}
