<?php

namespace App\Http\Controllers\Admin;

use DateTimeZone;
use App\Models\Config;
use App\Models\Setting;
use App\Models\Currency;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class EmailSettingController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    // General Settings
    public function index()
    {
        // Queries
        $timezonelist = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
        $currencies = Currency::get();
        $settings = Setting::first();
        $config = Config::get();

        // Get email configuration details
        $email_configuration = [
            'driver' => env('MAIL_MAILER', 'smtp'),
            'host' => env('MAIL_HOST', 'smtp.mailgun.org'),
            'port' => env('MAIL_PORT', 587),
            'username' => env('MAIL_USERNAME'),
            'password' => env('MAIL_PASSWORD'),
            'encryption' => env('MAIL_ENCRYPTION', 'tls'),
            'address' => env('MAIL_FROM_ADDRESS'),
            'name' => env('MAIL_FROM_NAME', $settings->site_name),
        ];

        $settings['email_configuration'] = $email_configuration;

        return view('admin.pages.settings.email', compact('settings', 'timezonelist', 'currencies', 'config'));
    }

    // Update Email Setting
    public function changeEmailSettings(Request $request)
    {
        // Mail username
        $mailDriver = str_replace('"', "", $request->mail_driver);
        $mailDriver = str_replace("'", "", $mailDriver);

        // Mail host
        $mailHost = str_replace('"', "", $request->mail_host);
        $mailHost = str_replace("'", "", $mailHost);

        // Mail port
        $mailPort = str_replace('"', "", $request->mail_port);
        $mailPort = str_replace("'", "", $mailPort);

        // Mail username
        $userName = str_replace('"', "", $request->mail_username);
        $userName = str_replace("'", "", $userName);

        // Mail password
        $password = str_replace('"', "", $request->mail_password);
        $password = str_replace("'", "", $password);

        // Mail password
        $mailEncryption = str_replace('"', "", $request->mail_encryption);
        $mailEncryption = str_replace("'", "", $mailEncryption);

        // Mail email
        $senderEmail = str_replace('"', "", $request->mail_address);
        $senderEmail = str_replace("'", "", $senderEmail);

        // Mail sender name
        $mailSenderName = str_replace('"', "", $request->mail_sender);
        $mailSenderName = str_replace("'", "", $mailSenderName);

        // Set new values using putenv (email)
        $this->updateEnvFile('MAIL_MAILER', $mailDriver);
        $this->updateEnvFile('MAIL_HOST', $mailHost);
        $this->updateEnvFile('MAIL_PORT', $mailPort);
        $this->updateEnvFile('MAIL_USERNAME', $userName);
        $this->updateEnvFile('MAIL_PASSWORD', $password);
        $this->updateEnvFile('MAIL_ENCRYPTION', $mailEncryption);
        $this->updateEnvFile('MAIL_FROM_ADDRESS', $senderEmail);
        $this->updateEnvFile('MAIL_FROM_NAME', '"'.$mailSenderName.'"');

        // Page redirect
        return redirect()->route('admin.email.settings')->with('success', trans('Email configurations updated successfully!'));
    }

    // Update change values in .env file
    public function updateEnvFile($key, $value)
    {
        $envPath = base_path('.env');

        // Check if the .env file exists
        if (file_exists($envPath)) {

            // Read the .env file
            $contentArray = file($envPath);

            // Loop through each line to find the key and update its value
            foreach ($contentArray as &$line) {

                // Split the line by '=' to get key and value
                $parts = explode('=', $line, 2);

                // Check if the key matches and update its value
                if (isset($parts[0]) && $parts[0] === $key) {
                    $line = $key . '=' . $value . PHP_EOL;
                }
            }

            // Implode the array back to a string and write it to the .env file
            $newContent = implode('', $contentArray);
            file_put_contents($envPath, $newContent);

            // Reload the environment variables
            putenv($key . '=' . $value);
            $_ENV[$key] = $value;
            $_SERVER[$key] = $value;
        }
    }
}
