<?php

namespace App\Http\Controllers\API;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Medias;
use App\Models\Optimer;
use Illuminate\Http\Request;
use App\Classes\APIS3Storage;
use App\Classes\APILocalStorage;
use App\Classes\APIWasabiStorage;
use App\Classes\APIBackblazeStorage;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\Models\Request as ModelsRequest;

class APIController extends Controller
{
    // Byte conversion
    public function formatBytes($size, $precision = 2)
    {
        $base = log($size, 1024);
        $suffixes = array('', 'kB', 'MB', 'GB', 'TB');

        return round(pow(1024, $base - floor($base)), $precision) . '' . $suffixes[floor($base)];
    }


    // Get status
    public function checkStatus(Request $request)
    {
        // Authorization
        $header = $request->header('Authorization');
        $userId = User::where('api_key', $header)->where('status', 1)->first();

        // Get used storage
        $usedStorage = Medias::where('user_id', $userId->id)->sum('size');

        // Check user type is "ADMIN"
        if ($userId->role_id == 1) {
            // Overall maximum & avilable optimize images, current and available storages
            $currentMaximum = "Unlimited";
            $availableMaximum = "Unlimited";
            $currentStorage = "Unlimited";
            $availableStorage = "Unlimited";
        } else {
            // Check unlimited
            if (json_decode($userId->plan_details)->maximum != 9999) {
                // Overall maximum optimize images
                $currentMaximum = json_decode($userId->plan_details)->maximum;
                // Overall available optimize images
                $usedOptimizes = Optimer::where('uploaded_by', $userId->id)->count();
                $availableMaximum = $currentMaximum - $usedOptimizes;
            } else {
                // Overall maximum optimize images
                $currentMaximum = "Unlimited";
                // Overall available optimize images
                $usedOptimizes = Optimer::where('uploaded_by', $userId->id)->count();
                $availableMaximum = "Unlimited";
            }

            // Overall storage
            $currentStorage = json_decode($userId->plan_details)->storage;
            // Available storage
            $availableStorage = $currentStorage - $usedStorage;

            // Get current storage convert bytes to kb, mb, tb
            $currentStorage = $this->formatBytes($currentStorage);

            // Get available storage convert bytes to kb, mb, tb
            $availableStorage = $this->formatBytes($availableStorage);
        }

        // Get used storage convert bytes to kb, mb, tb
        $usedStorage = $this->formatBytes($usedStorage);

        if ($usedStorage == "NAN") {
            $usedStorage = 0;
        }

        // Add request
        $apiRequest = new ModelsRequest();
        $apiRequest->user_id = $userId->id;
        $apiRequest->save();

        return response(['status' => true, 'maximum_optimize' => $currentMaximum, 'available_optimize' => $availableMaximum, 'current_storage' => $currentStorage, 'used_storage' => $usedStorage, 'available_storage' => $availableStorage], 200);
    }


    // Get all optimized images
    public function getOptimizedImages(Request $request)
    {
        // Authorization
        $header = $request->header('Authorization');
        $userId = User::where('api_key', $header)->where('status', 1)->first();

        // Get today optimize images
        $today_optimized_images = Optimer::where('uploaded_by', $userId->id)->whereDate('created_at', Carbon::today())->count();

        // Get today optimize image size
        $today_optimized_image_size = Optimer::where('uploaded_by', $userId->id)->whereDate('created_at', Carbon::today())->sum('optimized_image_size');

        // Get all optimize images
        $overallOptimizeImages = Optimer::where('uploaded_by', $userId->id)->count();

        // Get optimized images
        $images = Optimer::where('uploaded_by', $userId->id)->where('status', 1)->orderBy('id', 'desc')->get();

        $allOptImages = [];
        foreach ($images as $image) {
            // Check s3
            if (substr($image->optimized_image, 0, 5) == "https") {
                $url = $image->optimized_image;
            } else {
                $url = url($image->optimized_image);
            }
            $allOptImages[] = [
                'image_id' => $image->optimer_id,
                'name' => $image->name,
                'width' => $image->width,
                'height' => $image->height,
                'url' => $url,
                'size' => $image->optimized_image_size,
                'created_at' => $image->created_at
            ];
        }

        // Today optimized size
        $todayOptimizedSize = $this->formatBytes($today_optimized_image_size);

        if ($todayOptimizedSize == "NAN") {
            $todayOptimizedSize = 0;
        }

        // Add request
        $apiRequest = new ModelsRequest();
        $apiRequest->user_id = $userId->id;
        $apiRequest->save();

        return response(['status' => true, 'overall_optimized_images' => $overallOptimizeImages, 'today' => $today_optimized_images, 'today_optimized_size' => $todayOptimizedSize, 'all_images' => $allOptImages], 200);
    }


    // Get all media images
    public function getMediaImages(Request $request)
    {
        // Authorization
        $header = $request->header('Authorization');
        $userId = User::where('api_key', $header)->where('status', 1)->first();

        // Get today media images
        $today_media_images = Medias::where('user_id', $userId->id)->whereDate('created_at', Carbon::today())->count();

        // Get all media images
        $overAllMediaImages = Medias::where('user_id', $userId->id)->count();

        // Get media images
        $images = Medias::where('user_id', $userId->id)->where('status', '1')->orderBy('id', 'desc')->get();;

        $allMediaImages = [];
        foreach ($images as $image) {
            // Check s3
            if (substr($image->media_url, 0, 5) == "https") {
                $url = $image->media_url;
            } else {
                $url = url($image->media_url);
            }
            $allMediaImages[] = [
                'image_id' => $image->media_id,
                'name' => $image->media_name,
                'url' => $url,
                'size' => $image->size,
                'created_at' => $image->created_at
            ];
        }

        // Add request
        $apiRequest = new ModelsRequest();
        $apiRequest->user_id = $userId->id;
        $apiRequest->save();

        return response(['status' => true, 'overall_media_images' => $overAllMediaImages, 'today' => $today_media_images, 'all_images' => $allMediaImages], 200);
    }

    // Upload images
    public function uploadImage(Request $request)
    {
        // Check array
        if (gettype($request->images) == "array") {
            // Check media
            if ($request->media_upload == "true") {

                // Authorization
                $header = $request->header('Authorization');
                $userId = User::where('api_key', $header)->where('status', 1)->first();
                $plan_details = json_decode($userId->plan_details);

                // Check validity
                $validity = User::where('api_key', $header)->whereDate('plan_validity', '>=', Carbon::now())->count();

                // Get user created optimers overall size
                $overallMediaSize = Medias::where('user_id', $userId->id)->sum('size');

                if ($validity == 1 || $userId->role_id == 1) {
                    // Check storage available
                    if ($overallMediaSize < $plan_details->storage) {
                        $mediaUrl = [];

                        if (env('AWS_ENABLE') == 'on' && $plan_details->s3 == 1) {
                            // Upload local
                            $images = $request->file('images');

                            // Check loop
                            for ($i = 0; $i < count($images); $i++) {
                                // Check extension
                                if (
                                    $request->images[$i]->extension() == "svg" || $request->images[$i]->extension() == "jpg" || $request->images[$i]->extension() == "jpeg" || $request->images[$i]->extension() == "png" || $request->images[$i]->extension() == "webp" || $request->images[$i]->extension() == "gif"
                                ) {
                                    // Upload AWS S3
                                    $path = Storage::disk('s3')->put('files/' . $userId->id . '/media', $request->images[$i]);
                                    $request->merge([
                                        'size' => $request->images[$i]->getSize(),
                                        'path' => $path
                                    ]);

                                    $mediaImage = $request->only('path', 'title', 'size');

                                    $media = new Medias();
                                    $media->media_id = random_int(000000000000001, 99999999999999);
                                    $media->user_id = $userId->id;
                                    $media->media_name = $request->images[$i]->getClientOriginalName();
                                    $media->media_url = Storage::disk('s3')->url($path);
                                    $media->size = $request->images[$i]->getSize();
                                    $media->save();

                                    $mediaUrl[$i] = Storage::disk('s3')->url($path);
                                } else {
                                    return response(['status' => false, 'message' => 'Only supported for jpeg, png, webp, svg, gif files.'], 400);
                                }
                            }
                        } else if (env('WAS_ENABLE') == 'on' && $plan_details->s3 == 1) {
                            // Upload local
                            $images = $request->file('images');

                            // Check loop
                            for ($i = 0; $i < count($images); $i++) {
                                // Check extension
                                if (
                                    $request->images[$i]->extension() == "svg" || $request->images[$i]->extension() == "jpg" || $request->images[$i]->extension() == "jpeg" || $request->images[$i]->extension() == "png" || $request->images[$i]->extension() == "webp" || $request->images[$i]->extension() == "gif"
                                ) {
                                    // Upload wasabi
                                    $path = Storage::disk('wasabi')->put('files/' . $userId->id . '/media', $request->images[$i]);
                                    $request->merge([
                                        'size' => $request->images[$i]->getSize(),
                                        'path' => $path
                                    ]);

                                    $mediaImage = $request->only('path', 'title', 'size');

                                    $media = new Medias();
                                    $media->media_id = random_int(000000000000001, 99999999999999);
                                    $media->user_id = $userId->id;
                                    $media->media_name = $request->images[$i]->getClientOriginalName();
                                    $media->media_url = Storage::disk('wasabi')->url($path);
                                    $media->size = $request->images[$i]->getSize();
                                    $media->save();

                                    $mediaUrl[$i] = Storage::disk('wasabi')->url($path);
                                } else {
                                    return response(['status' => false, 'message' => 'Only supported for jpeg, png, webp, svg, gif files.'], 400);
                                }
                            }
                        } else if (env('BACK_ENABLE') == 'on' && $plan_details->s3 == 1) {
                            // Upload local
                            $images = $request->file('images');

                            // Check loop
                            for ($i = 0; $i < count($images); $i++) {
                                // Check extension
                                if (
                                    $request->images[$i]->extension() == "svg" || $request->images[$i]->extension() == "jpg" || $request->images[$i]->extension() == "jpeg" || $request->images[$i]->extension() == "png" || $request->images[$i]->extension() == "webp" || $request->images[$i]->extension() == "gif"
                                ) {
                                    // Upload backblaze
                                    $path = Storage::disk('backblaze')->put('files/' . $userId->id . '/media', $request->images[$i]);
                                    $request->merge([
                                        'size' => $request->images[$i]->getSize(),
                                        'path' => $path
                                    ]);

                                    $mediaImage = $request->only('path', 'title', 'size');

                                    $media = new Medias();
                                    $media->media_id = random_int(000000000000001, 99999999999999);
                                    $media->user_id = $userId->id;
                                    $media->media_name = $request->images[$i]->getClientOriginalName();
                                    $media->media_url = Storage::disk('backblaze')->url($path);
                                    $media->size = $request->images[$i]->getSize();
                                    $media->save();

                                    $mediaUrl[$i] = Storage::disk('backblaze')->url($path);
                                } else {
                                    return response(['status' => false, 'message' => 'Only supported for jpeg, png, webp, svg, gif files.'], 400);
                                }
                            }
                        } else {
                            // Upload local
                            $images = $request->file('images');

                            // Check loop
                            for ($i = 0; $i < count($images); $i++) {
                                // Check extension
                                if (
                                    $request->images[$i]->extension() == "svg" || $request->images[$i]->extension() == "jpg" || $request->images[$i]->extension() == "jpeg" || $request->images[$i]->extension() == "png" || $request->images[$i]->extension() == "webp" || $request->images[$i]->extension() == "gif"
                                ) {
                                    // Image name
                                    $imageName = random_int(000000000000001, 99999999999999) . '.' . $request->images[$i]->extension();
                                    $movedImage = $request->images[$i]->move(public_path('/storage/media/files/' . $userId->id . '/'), $imageName);

                                    $media = new Medias();
                                    $media->media_id = random_int(000000000000001, 99999999999999);
                                    $media->user_id = $userId->id;
                                    $media->media_name = $request->images[$i]->getClientOriginalName();
                                    $media->media_url = "/storage/media/files/" . $userId->id . '/' . $imageName;
                                    $media->size = $movedImage->getSize();
                                    $media->save();

                                    $mediaUrl[$i] = url("storage/media/files/" . $userId->id . '/' . $imageName);
                                } else {
                                    return response(['status' => false, 'message' => 'Only supported for jpeg, png, webp, svg, gif files.'], 400);
                                }
                            }
                        }

                        // Add request
                        $apiRequest = new ModelsRequest();
                        $apiRequest->user_id = $userId->id;
                        $apiRequest->save();

                        return response(['status' => true, 'download_url' => $mediaUrl], 200);
                    } else {
                        return response(['status' => false, 'message' => 'Storage limit is reached.'], 400);
                    }
                } else {
                    return response(['status' => false, 'message' => 'Your plan is over. Choose your plan renewal or new package and use it.'], 400);
                }
            } else {
                // Authorization
                $header = $request->header('Authorization');
                $userId = User::where('api_key', $header)->where('status', 1)->first();

                // Get user created optimers counts
                $optimers_counts = Optimer::where('uploaded_by', $userId->id)->count();

                // Get user created optimers overall size
                $optimers_size = Optimer::where('uploaded_by', $userId->id)->sum('actual_image_size');

                // Get plan details
                $plan_details = json_decode($userId->plan_details);

                // Check validity
                $validity = User::where('api_key', $header)->whereDate('plan_validity', '>=', Carbon::now())->count();

                // Check no of optimers
                if ($userId->role_id == 1 || $plan_details->maximum == 9999) {
                    $maximum = 9999999999;
                } else {
                    $maximum = $plan_details->maximum;
                }

                // Check storage available
                if ($validity == 1 || $userId->role_id == 1) {
                    if ($optimers_counts < $maximum && $optimers_size < $plan_details->storage) {
                        // Check s3 available
                        if (env('AWS_ENABLE') == 'on') {
                            if ($plan_details->s3 == 0) {
                                $storage = new APILocalStorage;
                                $storage->localFunction($request);
                            } else {
                                $storage = new APIS3Storage;
                                $storage->s3Function($request);
                            }
                        } else if (env('WAS_ENABLE') == 'on') {
                            if ($plan_details->s3 == 0) {
                                $storage = new APILocalStorage;
                                $storage->localFunction($request);
                            } else {
                                $storage = new APIWasabiStorage;
                                $storage->wasabiFunction($request);
                            }
                        } else if (env('BACK_ENABLE') == 'on') {
                            if ($plan_details->s3 == 0) {
                                $storage = new APILocalStorage;
                                $storage->localFunction($request);
                            } else {
                                $storage = new APIBackblazeStorage;
                                $storage->BackblazeFunction($request);
                            }
                        } else {
                            $storage = new APILocalStorage;
                            $storage->localFunction($request);
                        }

                        // Add request
                        $apiRequest = new ModelsRequest();
                        $apiRequest->user_id = $userId->id;
                        $apiRequest->save();

                        // dd($storage->status);
                        if ($storage->status === true) {
                            return response(['status' => true, 'download_url' => $storage->media_url], 200);
                        }
                        if ($storage->status === false) {
                            return response(['status' => false, 'message' => 'Only supported for jpeg, png, webp, svg, gif files.'], 400);
                        }
                        if ($storage->status === "unsupported") {
                            return response(['status' => false, 'message' => 'One of the image format is not supported.'], 400);
                        }
                    } else {
                        return response(['status' => false, 'message' => 'Maximum optimized image creation limit is exceeded, Please upgrade your plan.'], 400);
                    }
                } else {
                    return response(['status' => false, 'message' => 'Your plan is over. Choose your plan renewal or new package and use it.'], 400);
                }
            }
        } else {
            return response(['status' => false, 'message' => 'images must be array.'], 400);
        }
    }

    // Get single optimized images
    public function getSingleImage(Request $request)
    {
        // Authorization
        $header = $request->header('Authorization');
        $userId = User::where('api_key', $header)->where('status', 1)->first();

        // Parameter
        $imageId  = $request->image_id;

        // Get optimized images
        $singleImage = Optimer::where('uploaded_by', $userId->id)->where('optimer_id', $imageId)->where('status', 1)->first();

        // Check response
        if ($singleImage != null) {

            $getSingleImage = "";
            // Check s3
            if (substr($singleImage->optimized_image, 0, 5) == "https") {
                $url = $singleImage->optimized_image;
            } else {
                $url = url($singleImage->optimized_image);
            }
            $getSingleImage = [
                'image_id' => $singleImage->optimer_id,
                'name' => $singleImage->name,
                'width' => $singleImage->width,
                'height' => $singleImage->height,
                'url' => $url,
                'size' => $singleImage->optimized_image_size,
                'created_at' => $singleImage->created_at
            ];

            // Add request
            $apiRequest = new ModelsRequest();
            $apiRequest->user_id = $userId->id;
            $apiRequest->save();

            return response(['status' => true, 'single_image' => $getSingleImage], 200);
        } else {
            return response(['status' => false, 'message' => 'Invalid image id'], 400);
        }
    }


    // Get single / bulk optimized images
    public function deleteImages(Request $request)
    {
        // Authorization
        $header = $request->header('Authorization');
        $userId = User::where('api_key', $header)->where('status', 1)->first();

        // Parameter
        $imageIds  = $request->image_id;
        $permanentDelete = $request->permanent_delete;

        // 
        $deleteStatus = [];

        // Check array
        if (gettype($imageIds) == "array") {
            // Check permanent delete
            if ($permanentDelete == false) {
                for ($i = 0; $i < count($imageIds); $i++) {
                    // Soft delete optimized image
                    $imageDetails = Optimer::where('uploaded_by', $userId->id)->where('optimer_id', $imageIds[$i])->first();

                    if ($imageDetails != null) {
                        Optimer::where('optimer_id', $imageDetails->optimer_id)->where('uploaded_by', $userId->id)->update(['status' => 0]);
                        $deleteStatus[$i] = true;
                    } else {
                        $deleteStatus[$i] = false;
                    }
                }
            } else {
                for ($i = 0; $i < count($imageIds); $i++) {
                    // Optimer image details
                    $imageDetails = Optimer::where('optimer_id', $imageIds[$i])->where('uploaded_by', $userId->id)->first();

                    return response(['status' => false, 'message' => $imageIds[$i]], 400);

                    if ($imageDetails != null) {
                        if ($imageDetails->disk == 'local') {
                            // Delete local image (original image)
                            $actual_image = str_replace('/storage/files/' . $userId->id . '/', '', $imageDetails->actual_image);
                            unlink(public_path('storage/files/' . $userId->id . '/' . $actual_image));

                            // Delete local image (optimized image)
                            $optimized_image = str_replace('/storage/files/' . $userId->id . '/optimize/', '', $imageDetails->optimized_image);
                            unlink(public_path('storage/files/' . $userId->id . '/optimize/' . $optimized_image));
                        } else {
                            try {
                                // Delete s3 image
                                Storage::disk('s3')->delete(str_replace(Storage::disk('s3')->url('.'), '', $imageDetails->actual_image));
                                Storage::disk('s3')->delete(str_replace(Storage::disk('s3')->url('.'), '', $imageDetails->optimized_image));
                            } catch (\Throwable $th) {
                                //throw $th;
                            }

                            // Delete wasabi image
                            Storage::disk('wasabi')->delete(str_replace(Storage::disk('wasabi')->url('.'), '', $imageDetails->actual_image));
                            Storage::disk('wasabi')->delete(str_replace(Storage::disk('wasabi')->url('.'), '', $imageDetails->optimized_image));
                        }

                        // Update status
                        Optimer::where('optimer_id', $imageIds[$i])->where('uploaded_by', $userId->id)->delete();

                        $deleteStatus[$i] = true;
                    } else {
                        $deleteStatus[$i] = false;
                    }
                }
            }

            // Add request
            $apiRequest = new ModelsRequest();
            $apiRequest->user_id = $userId->id;
            $apiRequest->save();

            return response(['status' => true, 'delete' => $deleteStatus], 200);
        } else {
            return response(['status' => false, 'message' => 'image_id must be array.'], 400);
        }
    }
}
