<?php

namespace App\Classes;

use App\Models\Config;
use App\Models\Optimer;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Spatie\ImageOptimizer\OptimizerChain;
use Spatie\ImageOptimizer\Optimizers\Svgo;
use Spatie\ImageOptimizer\Optimizers\Cwebp;
use Spatie\ImageOptimizer\Optimizers\Gifsicle;
use Spatie\ImageOptimizer\Optimizers\Pngquant;
use Spatie\ImageOptimizer\Optimizers\Jpegoptim;

class s3MediaStorage
{
    public function s3MediaFunction($mediaDetails)
    {
        // Query
        $config = Config::get();

        // Request file
        $file = pathinfo($mediaDetails->media_url);

        // Generate Name, width, height
        $media_name = str_replace('/storage/media/files/' . Auth::user()->id . '/', '', $mediaDetails->media_url);
        $imageName = $media_name;
        $width = 0;
        $height = 0;

        // Get extension, original name, MIME type
        $extension = $file['extension'];
        $originalname = $file['filename'];
        $mimetype = $file['extension'];

        // Create optimize image folder
        $optimizePath = public_path() . '/storage/files/' . Auth::user()->id . '/optimize/';
        File::makeDirectory($optimizePath, 0777, true, true);

        // Move image original folder to optimize folder
        File::copy('storage/media/files/' . Auth::user()->id . '/' . $imageName, $optimizePath . $imageName);

        // Get image size in kb
        $imgsizes = filesize('storage/media/files/' . Auth::user()->id . '/' . $imageName);

        // Get image width and height
        if ($extension != "svg" || $extension != "SVG") {
            $width = 500;
            $height = 500;
        }

        // Upload AWS S3
        $path = Storage::disk('s3')->put('files/' . Auth::user()->id . '/' . $imageName, file_get_contents('storage/media/files/' . Auth::user()->id . '/' . $imageName));

        $optimizerChain = "";

        // Optimize Path (JPG)
        if ($extension == "jpg" || $extension == "jpeg" || $extension == "JPG" || $extension == "JPEG") {
            $optimizerChain = (new OptimizerChain)
                ->addOptimizer(new Jpegoptim([
                    '-m' . $config[38]->config_value, // set maximum quality to 85%
                    '--strip-all',  // this strips out all text information such as comments and EXIF data
                    '--all-progressive'  // this will make sure the resulting image is a progressive one
                ]));
        }

        // Optimize Path (PNG)
        if ($extension == "png" || $extension == "PNG") {
            $optimizerChain = (new OptimizerChain)
                ->addOptimizer(new Pngquant([
                    '--force' // required parameter for this package
                ]));
        }

        // Optimize Path (SVG)
        if ($extension == "svg" || $extension == "SVG") {
            $optimizerChain = (new OptimizerChain)
                ->addOptimizer(new Svgo([
                    '--disable={cleanupIDs,removeStyleElement, removeViewBox}', // disabling because it is know to cause 
                    '--enable={removeTitle,collapseGroups,convertPathData,removeDimensions,removeStyleElement,removeScriptElement,removeEmptyContainers}',
                ]));
        }

        // Optimize Path (GIF)
        if ($extension == "gif" || $extension == "GIF") {
            $optimizerChain = (new OptimizerChain)
                ->addOptimizer(new Gifsicle([
                    '-b', // required parameter for this package
                    '-0' // this produces the slowest but best results
                ]));
        }
        // Optimize Path (WEBP)
        if ($extension == "webp" || $extension == "WEBP") {
            $optimizerChain = (new OptimizerChain)
                ->addOptimizer(new Cwebp([
                    '-m 6', // for the slowest compression method in order to get the best compression.
                    '-pass 10', // for maximizing the amount of analysis pass.
                    '-mt', // multithreading for some speed improvements.
                    '-q ' . $config[39]->config_value, //quality factor that brings the least noticeable changes.
                ]));
        }

        // Optimize
        $optimizerChain->optimize('storage/media/files/' . Auth::user()->id . '/' . $imageName);

        // Get optimize image
        $optimizeImage = file_get_contents('storage/media/files/' . Auth::user()->id . '/' . $imageName);

        // Upload AWS S3
        $path = Storage::disk('s3')->put('files/' . Auth::user()->id . '/optimize/' . $imageName, $optimizeImage);

        // Get optimize image size
        $OptimizeAWSPathSize = filesize('storage/media/files/' . Auth::user()->id . '/' . $imageName);

        // Save Optimer
        $optimer = new Optimer();
        $optimer->optimer_id = random_int(000000000000001, 99999999999999);
        $optimer->uploaded_by = Auth::user()->id;
        $optimer->disk = 's3';
        $optimer->name = $originalname;
        $optimer->mime = $mimetype;
        $optimer->extension = $extension;
        $optimer->width = $width;
        $optimer->height = $height;
        $optimer->actual_image = Storage::disk('s3')->url('.') . "files/" . Auth::user()->id . '/' . $imageName;
        $optimer->optimized_image = Storage::disk('s3')->url('.') . "files/" . Auth::user()->id . '/optimize/' . $imageName;
        $optimer->cdn_url = Storage::disk('s3')->url('.') . "files/" . Auth::user()->id . '/optimize/' . $imageName;
        $optimer->actual_image_size = $imgsizes;
        $optimer->optimized_image_size = $OptimizeAWSPathSize;
        $optimer->save();

        $this->media_url = Storage::disk('s3')->url('.') . "files/" . Auth::user()->id . '/optimize/' . $imageName;

        return $this->media_url;
    }
}
