<?php

namespace App\Classes;

use App\Models\Config;
use Illuminate\Support\Facades\File;
use Spatie\ImageOptimizer\OptimizerChain;
use Spatie\ImageOptimizer\Optimizers\Svgo;
use Spatie\ImageOptimizer\Optimizers\Cwebp;
use Spatie\ImageOptimizer\Optimizers\Gifsicle;
use Spatie\ImageOptimizer\Optimizers\Pngquant;
use Spatie\ImageOptimizer\Optimizers\Jpegoptim;

class NonStorage
{
    public function nonStorageFunction($request)
    {
        // Query
        $config = Config::get();

        // Request file
        $file = $request->file('file');

        // Generate Name, width, height
        $random = random_int(000000000000001, 99999999999999);
        $imageName = $random . '.' . $request->file->extension();
        $width = 0;
        $height = 0;

        // Get extension, original name, MIME type
        $extension = $file->getClientOriginalExtension();
        $originalname = $file->getClientOriginalName();
        $mimetype = $file->getClientMimeType();

        // Move original image
        $originalPath = $request->file->move(public_path('/storage/files/' . $random . '/'), $imageName);

        // Create optimize image folder
        $optimizePath = public_path() . '/storage/files/' . $random . '/optimize/';
        File::makeDirectory($optimizePath, 0777, true, true);

        // Move image original folder to optimize folder
        File::copy(public_path('/storage/files/' . $random . '/' . $imageName), $optimizePath . $imageName);

        // Get image size in kb
        $imgsizes = $originalPath->getSize();

        // Get image width and height
        if ($extension != "svg" || $extension != "SVG") {
            // $data = getimagesize($originalPath);
            // $width = $data[0];
            // $height = $data[1];
            $width = 500;
            $height = 500;
        }

        $optimizerChain = "";

        // Optimize Path (JPG)
        if ($extension == "jpg" || $extension == "jpeg" || $extension == "JPG" || $extension == "JPEG") {
            $optimizerChain = (new OptimizerChain)
                ->addOptimizer(new Jpegoptim([
                    '-m' . $config[38]->config_value, // set maximum quality to 85%
                    '--strip-all',  // this strips out all text information such as comments and EXIF data
                    '--all-progressive'  // this will make sure the resulting image is a progressive one
                ]));
        }

        // Optimize Path (PNG)
        if ($extension == "png" || $extension == "PNG") {
            $optimizerChain = (new OptimizerChain)
                ->addOptimizer(new Pngquant([
                    '--force' // required parameter for this package
                ]));
        }

        // Optimize Path (SVG)
        if ($extension == "svg" || $extension == "SVG") {
            $optimizerChain = (new OptimizerChain)
                ->addOptimizer(new Svgo([
                    '--disable={cleanupIDs,removeStyleElement, removeViewBox}', // disabling because it is know to cause 
                    '--enable={removeTitle,collapseGroups,convertPathData,removeDimensions,removeStyleElement,removeScriptElement,removeEmptyContainers}',
                ]));
        }

        // Optimize Path (GIF)
        if ($extension == "gif" || $extension == "GIF") {
            $optimizerChain = (new OptimizerChain)
                ->addOptimizer(new Gifsicle([
                    '-b', // required parameter for this package
                    '-0' // this produces the slowest but best results
                ]));
        }
        // Optimize Path (WEBP)
        if ($extension == "webp" || $extension == "WEBP") {
            $optimizerChain = (new OptimizerChain)
                ->addOptimizer(new Cwebp([
                    '-m 6', // for the slowest compression method in order to get the best compression.
                    '-pass 10', // for maximizing the amount of analysis pass.
                    '-mt', // multithreading for some speed improvements.
                    '-q ' . $config[39]->config_value, //quality factor that brings the least noticeable changes.
                ]));
        }

        // Optimize
        $optimizerChain->optimize(public_path('storage/files/' . $random . '/optimize/' . $imageName));

        // Get optimize image size
        $afterOptimizePath = filesize($optimizePath . $imageName);

        $savedYou = (int)($imgsizes - $afterOptimizePath);

        // Response
        $this->fileName = $originalname;
        $this->originalSizes = $imgsizes;
        $this->optimizeSizes = $afterOptimizePath;
        $this->savedYou = $savedYou;
        $this->optimizeUrl = '/storage/files/' . $random . '/optimize/' . $imageName;

        return $this->fileName;
        return $this->originalSizes;
        return $this->optimizeSizes;
        return $this->savedYou;
        return $this->optimizeUrl;
    }
}
